/*
 * JBoss, the OpenSource WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.web.tomcat.security;

import javax.security.auth.callback.Callback;
import javax.servlet.http.HttpServletRequest;

/**
 * An implementation of Callback that obtains the HttpServletRequest from the
 * the client trying to authenticate.
 * 
 * @author Ricardo Arguello (ricardoarguello@users.sourceforge.net)
 * @version $Revision:1$
 */
public class HttpServletRequestCallback implements Callback
{
   private transient HttpServletRequest request;

   public HttpServletRequestCallback()
   {
   }

   public HttpServletRequest getHttpServletRequest()
   {
      return request;
   }

   public void setHttpServletRequest(HttpServletRequest request)
   {
      this.request = request;
   }
}