/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.net.ssl;

import org.apache.tomcat.util.net.ServerSocketFactory;
import org.apache.tomcat.util.net.jsse.JSSEImplementation;

/**
 * Extend the default tomcat JSSEImplementation to use the JBossSocketFactory
 * for integration with the SecurityDomain based key/trust store configuration
 * 
 * @see JSSEImplementation
 * @see JBossSocketFactory
 * @see org.jboss.security.SecurityDomain
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */ 
public class JBossImplementation
   extends JSSEImplementation
{
   public JBossImplementation()
      throws ClassNotFoundException
   {
      super();
   }

   public String getImplementationName()
   {
      return "JBoss";
   }

   public ServerSocketFactory getServerSocketFactory()
   {
      return new JBossSocketFactory();
   }

}
