/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.xml.multispaced.pm.jdbc;

import org.jboss.xml.binding.ObjectModelProvider;
import org.jboss.test.xml.multispaced.XMBeanMetaData;
import org.jboss.logging.Logger;

/**
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 */
public class JDBCPmMetaDataProvider
   implements ObjectModelProvider
{
   private static final Logger log = Logger.getLogger(JDBCPmMetaDataFactory.class);

   private final JDBCPm pm;

   public JDBCPmMetaDataProvider(JDBCPm pm)
   {
      this.pm = pm;
   }

   public Object getRoot(Object o, String namespaceURI, String localName)
   {
      log.debug("getRoot(): o=" + o.getClass());
      return pm;
   }

   public Object getChildren(JDBCPm pm, String namespaceUri, String localName)
   {
      log.debug("getChildren> ns=" + namespaceUri + ", localName=" + localName);
      return null;
   }

   public Object getElementValue(JDBCPm pm, String namespaceUri, String localName)
   {
      log.debug("getValue> ns=" + namespaceUri + ", localName=" + localName);
      Object child = null;
      if("datasource".equals(localName))
      {
         child = pm.getDatasource();
      }
      else if("table".equals(localName))
      {
         child = pm.getTable();
      }
      return child;
   }
}
