/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.xml.multispaced;

/**
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 */
public class XMBeanOperationMetaData
{
   private String description;
   private String name;
   private String returnType;

   public String getDescription()
   {
      return description;
   }

   public void setDescription(String description)
   {
      this.description = description;
   }

   public String getName()
   {
      return name;
   }

   public void setName(String name)
   {
      this.name = name;
   }

   public String getReturnType()
   {
      return returnType;
   }

   public void setReturnType(String returnType)
   {
      this.returnType = returnType;
   }

   public String toString()
   {
      return "[name=" + name + ", return-type=" + returnType + ", description=" + description + ']';
   }

   public boolean equals(Object o)
   {
      if(this == o) return true;
      if(!(o instanceof XMBeanOperationMetaData)) return false;

      final XMBeanOperationMetaData mBeanOperationMetaData = (XMBeanOperationMetaData)o;

      if(description != null ? !description.equals(mBeanOperationMetaData.description) : mBeanOperationMetaData.description != null) return false;
      if(name != null ? !name.equals(mBeanOperationMetaData.name) : mBeanOperationMetaData.name != null) return false;
      if(returnType != null ? !returnType.equals(mBeanOperationMetaData.returnType) : mBeanOperationMetaData.returnType != null) return false;

      return true;
   }

   public int hashCode()
   {
      int result;
      result = (description != null ? description.hashCode() : 0);
      result = 29 * result + (name != null ? name.hashCode() : 0);
      result = 29 * result + (returnType != null ? returnType.hashCode() : 0);
      return result;
   }
}
