/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.xml.book;

import org.jboss.xml.binding.ObjectModelProvider;

/**
 * org.jboss.xml.binding.ObjectModelProvider implementation that provides data to marshaller given
 * specific Book instance.
 *
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 */
public class BookObjectProvider
   implements ObjectModelProvider
{
   public Object getRoot(Object o, String namespaceURI, String localName)
   {
      return o;
   }

   public Object getChildren(Book book, String namespaceUri, String localName)
   {
      Object children = null;
      if(localName.equals("book"))
      {
         children = book;
      }
      else if(localName.equals("character"))
      {
         children = book.getCharacters();
      }
      return children;
   }

   public Object getAttributeValue(Book book, String namespaceUri, String localName)
   {
      Object value;
      if("isbn".equals(localName))
      {
         value = book.getIsbn();
      }
      else
      {
         value = null;
      }
      return value;
   }

   public Object getElementValue(Book book, String namespaceUri, String localName)
   {
      Object value;
      if("title".equals(localName))
      {
         value = book.getTitle();
      }
      else if("author".equals(localName))
      {
         value = book.getAuthor();
      }
      else
      {
         value = null;
      }
      return value;
   }

   public Object getElementValue(BookCharacter character, String namespaceUri, String localName)
   {
      Object value = null;
      if("name".equals(localName))
      {
         value = character.getName();
      }
      else if("friend-of".equals(localName))
      {
         value = character.getFriendOf();
      }
      else if("since".equals(localName))
      {
         value = character.getSince();
      }
      else if("qualification".equals(localName))
      {
         value = character.getQualification();
      }
      return value;
   }
}
