/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.xml.book;

import org.xml.sax.Attributes;
import org.jboss.xml.binding.ContentNavigator;
import org.jboss.xml.binding.ObjectModelFactory;

/**
 * org.jboss.xml.binding.ObjectModelFactory implementation that accepts data chuncks from unmarshaller
 * and assembles them into an instance Book.
 *
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 * @version <tt>$Revision:1$</tt>
 */
public class BookObjectFactory
   implements ObjectModelFactory
{
   // ObjectModelFactory implementation

   /**
    * Return the root.
    */
   public Object newRoot(Object root,
                         ContentNavigator navigator,
                         String namespaceURI,
                         String localName,
                         Attributes attrs)
   {
      final Book book;
      if(root == null)
      {
         root = book = new Book();
      }
      else
      {
         book = (Book) root;
      }

      if(attrs.getLength() > 0)
      {
         for(int i = 0; i < attrs.getLength(); ++i)
         {
            if(attrs.getLocalName(i).equals("isbn"))
            {
               book.setIsbn(attrs.getValue(i));
            }
         }
      }

      return root;
   }

   // Methods discovered by introspection

   /**
    * Called when a child element with simple content is read for book.
    */
   public void setValue(Book book,
                        ContentNavigator navigator,
                        String namespaceURI,
                        String localName,
                        String value)
   {
      if("title".equals(localName))
      {
         book.setTitle(value);
      }
      else if("author".equals(localName))
      {
         book.setAuthor(value);
      }
   }

   /**
    * Called when parsing of a new element started.
    */
   public Object newChild(Book book,
                          ContentNavigator navigator,
                          String namespaceURI,
                          String localName,
                          Attributes attrs)
   {
      Object child = null;
      if("character".equals(localName))
      {
         child = new BookCharacter();
      }
      return child;
   }

   /**
    * Called when a child element with simple content is read for character.
    */
   public void setValue(BookCharacter character,
                        ContentNavigator navigator,
                        String namespaceURI,
                        String localName,
                        String value)
   {
      if("name".equals(localName))
      {
         character.setName(value);
      }
      else if("friend-of".equals(localName))
      {
         character.setFriendOf(value);
      }
      else if("since".equals(localName))
      {
         character.setSince(value);
      }
      else if("qualification".equals(localName))
      {
         character.setQualification(value);
      }
   }

   /**
    * Called when parsing character is complete.
    */
   public void addChild(Book book,
                        BookCharacter character,
                        ContentNavigator navigator,
                        String namespaceURI,
                        String localName)
   {
      book.addCharacter(character);
   }
}
