/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.xml.book;

import org.jboss.xml.binding.GenericObjectModelProvider;

/**
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 * @version <tt>$Revision:1$</tt>
 */
public class BookGenericObjectModelProvider
   implements GenericObjectModelProvider
{
   public Object getChildren(Object o, String namespaceURI, String localName)
   {
      Object children = null;
      if(o instanceof Book)
      {
         Book book = (Book)o;
         if(localName.equals("character"))
         {
            children = book.getCharacters();
         }
         else if(localName.equals("book"))
         {
            children = book;
         }
      }
      return children;
   }

   public Object getElementValue(Object o, String namespaceURI, String localName)
   {
      Object value = null;
      if(o instanceof Book)
      {
         Book book = (Book)o;
         if("title".equals(localName))
         {
            value = book.getTitle();
         }
         else if("author".equals(localName))
         {
            value = book.getAuthor();
         }
      }
      else if(o instanceof BookCharacter)
      {
         BookCharacter character = (BookCharacter)o;
         if("name".equals(localName))
         {
            value = character.getName();
         }
         else if("friend-of".equals(localName))
         {
            value = character.getFriendOf();
         }
         else if("since".equals(localName))
         {
            value = character.getSince();
         }
         else if("qualification".equals(localName))
         {
            value = character.getQualification();
         }
      }
      return value;
   }

   public Object getAttributeValue(Object o, String namespaceURI, String localName)
   {
      Object value = null;
      if(o instanceof Book)
      {
         Book book = (Book)o;
         if("isbn".equals(localName))
         {
            value = book.getIsbn();
         }
      }
      return value;
   }

   public Object getRoot(Object o, String namespaceURI, String localName)
   {
      return o;
   }
}
