/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.xml.book;

import org.jboss.xml.binding.GenericObjectModelFactory;
import org.jboss.xml.binding.ContentNavigator;
import org.xml.sax.Attributes;

/**
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 * @version <tt>$Revision:1$</tt>
 */
public class BookGenericObjectModelFactory
   implements GenericObjectModelFactory
{
   public Object newRoot(Object root,
                         ContentNavigator navigator,
                         String namespaceURI,
                         String localName,
                         Attributes attrs)
   {
      final Book book;
      if(root == null)
      {
         root = book = new Book();
      }
      else
      {
         book = (Book) root;
      }

      if(attrs.getLength() > 0)
      {
         for(int i = 0; i < attrs.getLength(); ++i)
         {
            if(attrs.getLocalName(i).equals("isbn"))
            {
               book.setIsbn(attrs.getValue(i));
            }
         }
      }

      return root;
   }

   public Object newChild(Object parent,
                          ContentNavigator navigator,
                          String namespaceURI,
                          String localName,
                          Attributes attrs)
   {
      Object child = null;
      if(parent instanceof Book)
      {
         if("character".equals(localName))
         {
            child = new BookCharacter();
         }
      }
      return child;
   }

   public void addChild(Object parent,
                        Object child,
                        ContentNavigator navigator,
                        String namespaceURI,
                        String localName)
   {
      if(parent instanceof Book)
      {
         final Book book = (Book)parent;
         if(child instanceof BookCharacter)
         {
            book.addCharacter((BookCharacter)child);
         }
      }
   }

   public void setValue(Object o, ContentNavigator navigator, String namespaceURI, String localName, String value)
   {
      if(o instanceof Book)
      {
         final Book book = (Book)o;
         if("title".equals(localName))
         {
            book.setTitle(value);
         }
         else if("author".equals(localName))
         {
            book.setAuthor(value);
         }
      }
      else if(o instanceof BookCharacter)
      {
         BookCharacter character = (BookCharacter)o;
         if("name".equals(localName))
         {
            character.setName(value);
         }
         else if("friend-of".equals(localName))
         {
            character.setFriendOf(value);
         }
         else if("since".equals(localName))
         {
            character.setSince(value);
         }
         else if("qualification".equals(localName))
         {
            character.setQualification(value);
         }
      }
   }

   public Object completedRoot(Object root, ContentNavigator navigator, String namespaceURI, String localName)
   {
      return root;
   }
}
