/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.webservice.ws4eesimple;

import org.jboss.logging.Logger;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.rpc.Service;
import java.io.IOException;
import java.io.PrintWriter;

public class HelloWsClientServlet extends HttpServlet
{
   // provide logging
   private static final Logger log = Logger.getLogger(HelloWsClientServlet.class);

   protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
   {
      response.setContentType("text/plain");
      PrintWriter pw = response.getWriter();
      try
      {
         InitialContext iniCtx = new InitialContext();
         Service service = (Service)iniCtx.lookup("java:comp/env/service/HelloWsService");
         HelloWs sei = (HelloWs)service.getPort(HelloWs.class);

         String input = request.getParameter("input");
         String output = sei.sayHello(input);

         pw.println(output);
      }
      catch (Exception e)
      {
         log.error("Access failed", e);
         e.printStackTrace(pw);
      }
      finally
      {
         pw.close();
      }
   }
}
