/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.webservice.ws4eesimple;

import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.xml.rpc.Service;
import java.rmi.RemoteException;

public class HelloClientBean implements SessionBean
{

   public String sayHello(String input) throws RemoteException
   {
      try
      {
         InitialContext iniCtx = new InitialContext();
         Service service = (Service) iniCtx.lookup("java:comp/env/service/HelloWsService");
         HelloWs sei = (HelloWs) service.getPort(HelloWs.class);

         String output = sei.sayHello(input);
         return output;
      }
      catch (Exception e)
      {
         return e.toString();
      }
   }

   // EJB life cycle methods *******************************************************************************************

   public void ejbCreate()
   {
   }

   public void ejbRemove()
   {
   }

   public void ejbActivate()
   {
   }

   public void ejbPassivate()
   {
   }

   public void setSessionContext(SessionContext sc)
   {
   }
}
