/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.ws4eesimple;

// $Id:ClientStubTestCase.java,v 1.0, 2005-06-24 18:58:06Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.test.webservice.WebserviceTestBase;

import javax.naming.Context;
import javax.xml.rpc.Service;
import javax.xml.rpc.Stub;

/**
 * Tests the JBossWS client stub
 *
 * @author Thomas.Diesler@jboss.org
 * @since 09-Nov-2004
 */
public class ClientStubTestCase extends WebserviceTestBase
{
   private static final String WS4EE_CLIENT_TIMEOUT = "org.jboss.webservice.client.timeout";

   /**
    * Construct the test case with a given name
    */
   public ClientStubTestCase(String name)
   {
      super(name);
   }

   /**
    * deploy the test archives
    */
   public static Test suite() throws Exception
   {
      return getDeploySetup(ClientStubTestCase.class, "ws4ee-simple.jar, ws4ee-simple-client.ear");
   }

   /**
    * Test client application access
    */
   public void testClientStub() throws Exception
   {
      Context iniCtx = getClientContext();
      Service service = (Service)iniCtx.lookup("java:comp/env/service/HelloWsService");
      HelloWs port = (HelloWs)service.getPort(HelloWs.class);

      String res = port.sayHello("Hello");
      assertEquals("'Hello' to you too!", res);

      Stub stub = (Stub)port;
      stub._setProperty(Stub.USERNAME_PROPERTY, "kermit");
      assertEquals("kermit", stub._getProperty(Stub.USERNAME_PROPERTY));

      stub._setProperty(Stub.PASSWORD_PROPERTY, "thefrog");
      assertEquals("thefrog", stub._getProperty(Stub.PASSWORD_PROPERTY));

      Boolean sessionMaintain = (Boolean)stub._getProperty(Stub.SESSION_MAINTAIN_PROPERTY);
      assertTrue(sessionMaintain == null || sessionMaintain.booleanValue() == false);
      stub._setProperty(Stub.SESSION_MAINTAIN_PROPERTY, new Boolean(true));
      assertTrue(((Boolean)stub._getProperty(Stub.SESSION_MAINTAIN_PROPERTY)).booleanValue());

      assertEquals("http://" + getServerHost() + ":8080/ws4ee-simple/HelloWsService", stub._getProperty(Stub.ENDPOINT_ADDRESS_PROPERTY));
      stub._setProperty(Stub.ENDPOINT_ADDRESS_PROPERTY, "http://" + getServerHost() + ":8080/ws4ee-simple/DummyService");
      assertEquals("http://" + getServerHost() + ":8080/ws4ee-simple/DummyService", stub._getProperty(Stub.ENDPOINT_ADDRESS_PROPERTY));

      stub._setProperty(WS4EE_CLIENT_TIMEOUT, new Integer(100));
      assertEquals(new Integer(100), stub._getProperty(WS4EE_CLIENT_TIMEOUT));
   }
}
