/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.version;

// $Id:VersionTestCase.java,v 1.0, 2005-06-24 19:18:56Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.test.webservice.WebserviceTestBase;

import javax.naming.InitialContext;
import javax.xml.rpc.Service;

/**
 * Test access to the /ws4ee/services/Version service
 *
 * @author Thomas.Diesler@jboss.org
 * @since 08-Feb-2005
 */
public class VersionTestCase extends WebserviceTestBase
{
   /** Construct the test case with a given name
    */
   public VersionTestCase(String name)
   {
      super(name);
   }

   /** Deploy the test */
   public static Test suite() throws Exception
   {
      return getDeploySetup(VersionTestCase.class, "ws4ee-version-client.jar");
   }

   /**
    * Test JSE endpoint
    */
   public void testEndpoint() throws Exception
   {
      InitialContext iniCtx = getClientContext();
      Service service = (Service)iniCtx.lookup("java:comp/env/service/VersionService");
      Version port = (Version)service.getPort(Version.class);

      String versionStr = port.getVersion();
      System.out.println("Version: " + versionStr);
      assertNotNull(versionStr);
   }
}
