/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.samples2;

// $Id:OrderProcessWrappedImpl.java,v 1.0, 2005-06-24 19:13:31Z, Robert Worsnop$

/**
 * An example of a wrapped service endpoint impl
 *
 * @author Thomas.Diesler@jboss.org
 * @since 26-Apr-2004
 */
public class OrderProcessWrappedImpl implements OrderProcessWrapped
{
   public OrderProcess_processOrder_ResponseStruct processOrder(OrderProcess_processOrder_RequestStruct req) throws OrderException
   {
      OrderItem[] items = req.getArrayOfOrderItem_1();
      Person person = req.getPerson_2();

      if (person == null || person.getName() == null)
         throw new OrderException("Invalid person");

      if (items == null)
         throw new OrderException("Invalid order items");

      if (items.length > 3)
         throw new OrderException("Too many order items");

      OrderResponse ordRes = new OrderResponse(items, "aproved");

      OrderProcess_processOrder_ResponseStruct res = new OrderProcess_processOrder_ResponseStruct(ordRes);
      return res;
   }
}
