/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.samples;

// $Id:OrganizationJSEEndpoint.java,v 1.0, 2005-06-24 19:13:32Z, Robert Worsnop$

import org.jboss.logging.Logger;

import javax.xml.rpc.ServiceException;
import javax.xml.rpc.server.ServiceLifecycle;
import javax.xml.rpc.server.ServletEndpointContext;

/**
 * An example of a java service endpoint.
 *
 * @author Thomas.Diesler@jboss.org
 * @since 26-Apr-2004
 */
public class OrganizationJSEEndpoint implements Organization, ServiceLifecycle
{
   // provide logging
   private static final Logger log = Logger.getLogger(OrganizationJSEEndpoint.class);

   private ServletEndpointContext ctx;

   public String getContactInfo(String organization)
   {
      log.info("getContactInfo: " + organization);
      return "The '" + organization + "' boss is currently out of office, please call again.";
   }

   public Person jobRequest(Person target)
   {
      log.info("jobRequest: " + target);
      return target;
   }

   /** Used for initialization of a service endpoint.
    */
   public void init(Object context) throws ServiceException
   {
      ctx = (ServletEndpointContext)context;
      log.info("init: " + ctx);
   }

   /** JAX-RPC runtime system ends the lifecycle of a service endpoint instance by
    * invoking the destroy method. 
    */
   public void destroy()
   {
      log.info("destroy: " + ctx);
   }
}
