/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.samples;

// $Id:OrganizationClientBean.java,v 1.0, 2005-06-24 19:13:32Z, Robert Worsnop$

import org.jboss.logging.Logger;

import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.rpc.Service;
import java.rmi.RemoteException;

/**
 * An example of a SLSB
 *
 * @author Thomas.Diesler@jboss.org
 * @since 26-Apr-2004
 */
public class OrganizationClientBean implements SessionBean
{
   // provide logging
   private static final Logger log = Logger.getLogger(OrganizationClientBean.class);

   /** Get the contact info from the EJB service */
   public String getContactInfoEJB(String organization) throws RemoteException
   {
      Service service = null;
      try
      {
         InitialContext iniCtx = new InitialContext();
         service = (Service)iniCtx.lookup("java:/comp/env/service/OrganizationServiceEJB");
         Organization endpoint = (Organization)service.getPort(Organization.class);
         String info = endpoint.getContactInfo(organization);
         return info;
      }
      catch (NamingException e)
      {
         throw new EJBException(e);
      }
      catch (Exception e)
      {
         throw new EJBException("Cannot invoke webservice", e);
      }
   }

   /** Get the contact info from the JSE service */
   public String getContactInfoJSE(String organization) throws RemoteException
   {
      try
      {
         InitialContext iniCtx = new InitialContext();
         OrganizationService service = (OrganizationService)iniCtx.lookup("java:comp/env/service/OrganizationServiceJSE");
         Organization endpoint = (Organization)service.getOrganizationPort();
         String info = endpoint.getContactInfo(organization);
         return info;
      }
      catch (NamingException e)
      {
         throw new EJBException(e);
      }
      catch (Exception e)
      {
         throw new EJBException("Cannot invoke webservice", e);
      }
   }

   // SLSB Lifecycle ***************************************************************************************************

   public void ejbCreate()
   {
   }

   public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException
   {
   }

   public void ejbRemove() throws EJBException, RemoteException
   {
   }

   public void ejbActivate() throws EJBException, RemoteException
   {
   }

   public void ejbPassivate() throws EJBException, RemoteException
   {
   }
}
