/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.samples;


// $Id:ClientSideApplTestCase.java,v 1.0, 2005-06-24 18:58:04Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.test.webservice.WebserviceTestBase;

import javax.naming.InitialContext;
import javax.xml.rpc.Service;

/**
 * Test access to the webservice via an application client
 *
 * @author Thomas.Diesler@jboss.org
 * @since 26-Apr-2004
 */
public class ClientSideApplTestCase extends WebserviceTestBase
{

   public ClientSideApplTestCase(String name)
   {
      super(name);
   }

   /** Deploy the test */
   public static Test suite() throws Exception
   {
      return getDeploySetup(ClientSideApplTestCase.class, "ws4ee-samples-server-jse.war, ws4ee-samples-server-ejb.jar, ws4ee-samples-client-appl.jar");
   }

   /** Test access to the EJB endpoint */
   public void testApplClientAccessEJB() throws Exception
   {
      InitialContext iniCtx = getClientContext();
      Service service = (Service)iniCtx.lookup("java:comp/env/service/OrganizationServiceEJB");
      Organization endpoint = (Organization)service.getPort(Organization.class);
      String info = endpoint.getContactInfo("mafia");
      assertEquals("The 'mafia' boss is currently out of office, please call again.", info);
   }

   /** Test access to the JSE endpoint */
   public void testApplClientAccessJSE() throws Exception
   {
      InitialContext iniCtx = getClientContext();
      OrganizationService service = (OrganizationService)iniCtx.lookup("java:comp/env/service/OrganizationServiceJSE");
      Organization endpoint = service.getOrganizationPort();
      String info = endpoint.getContactInfo("mafia");
      assertEquals("The 'mafia' boss is currently out of office, please call again.", info);

      Person bill = new Person("Bill", 56);
      Person ret = endpoint.jobRequest(bill);
      assertEquals(bill, ret);
   }
}
