/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.message;

// $Id:Message.java,v 1.0, 2005-06-24 19:12:07Z, Robert Worsnop$

import org.w3c.dom.Element;

import java.rmi.Remote;
import java.rmi.RemoteException;

/**
 * @author Thomas.Diesler@jboss.org
 * @since 26-Nov-2004
 */
public interface Message extends Remote
{
   static final String NSURI_1 = "http://org.jboss.test.webservice/message";
   static final String PREFIX_1 = "ns1";

   static final String NSURI_2 = "http://somens";
   static final String PREFIX_2 = "ns2";

   String request =
           "<ns1:Order xmlns:ns1='http://org.jboss.test.webservice/message' xmlns:ns2='http://somens' attrval='somevalue'>" +
           "  <ns2:Customer>Kermit</ns2:Customer>" +
           "  <Item>Ferrari</Item>" +
           "</ns1:Order>";

   String response =
           "<ns1:Response xmlns:ns1='http://org.jboss.test.webservice/message'>" +
           "  <POID>12345</POID>" +
           "  <Status>ok</Status>" +
           "</ns1:Response>";

   public Element processElement(Element msg) throws RemoteException;
}
