/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.marshalltest;

// $Id:MarshallRpcEncodedTestCase.java,v 1.0, 2005-06-24 19:11:41Z, Robert Worsnop$

import junit.framework.Test;

import javax.naming.InitialContext;
import javax.xml.rpc.Service;

/**
 * Tests of the ws4ee rpc-encoded marshalling
 *
 * @author Thomas.Diesler@jboss.org
 * @since 09-May-2004
 */
public class MarshallRpcEncodedTestCase extends AbstractRpcTestBase
{
   /**
    * Construct the test case with a given name
    */
   public MarshallRpcEncodedTestCase(String name)
   {
      super(name);
   }

   /**
    * deploy the test archives
    */
   public static Test suite() throws Exception
   {
      return getDeploySetup(MarshallRpcEncodedTestCase.class, "ws4ee-marshall-rpcenc.ear");
   }

   protected void setUp() throws Exception
   {
      super.setUp();
      if (rpcPort == null)
      {
         InitialContext iniCtx = getClientContext();
         Service service = (Service)iniCtx.lookup("java:comp/env/service/MarshallRpcEncService");
         rpcPort = (MarshallRpcServiceInterface)service.getPort(MarshallRpcServiceInterface.class);
      }
   }
}
