/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.webservice.marshalltest;

import org.jboss.test.webservice.marshalltest.types.Bean;

import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.xml.namespace.QName;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;

/**
* @ejb.bean name="MarshallRpcBean"
*           jndi-name="test/webservice/MarshallRpcBean"
*           display-name="Stateless Session Bean"
*           type="Stateless"
*           transaction-type="Container"
*           view-type="remote"
*/
public class MarshallRpcBeanImpl implements SessionBean
{

   /**
    * @ejb.interface-method view-type="remote"
    */
   public String echoString(String v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public BigInteger echoInteger(BigInteger v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public int echoInt(int v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public long echoLong(long v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public short echoShort(short v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public BigDecimal echoDecimal(BigDecimal v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public float echoFloat(float v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public double echoDouble(double v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public boolean echoBoolean(boolean v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public byte echoByte(byte v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public QName echoQName(QName v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public Calendar echoDateTimeCalendar(Calendar v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public Date echoDateTimeDate(Date v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public Calendar echoDateCalendar(Calendar v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public Date echoDateDate(Date v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public byte[] echoBase64Binary(byte[] v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public byte[] echoHexBinary(byte[] v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public Bean echoBean(Bean bean)
   {
      return bean;
   }

   //
   // array methods
   //

   /**
    * @ejb.interface-method view-type="remote"
    */
   public String[] echoStringArray(String[] v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public BigInteger[] echoIntegerArray(BigInteger[] v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public int[] echoIntArray(int[] v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public long[] echoLongArray(long[] v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public short[] echoShortArray(short[] v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public BigDecimal[] echoDecimalArray(BigDecimal[] v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public float[] echoFloatArray(float[] v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public double[] echoDoubleArray(double[] v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public boolean[] echoBooleanArray(boolean[] v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public byte[] echoByteArray(byte[] v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public QName[] echoQNameArray(QName[] v)
   {
      return v;
   }

   /**
    * @ejb.interface-method view-type="remote"
    */
   public Calendar[] echoDateTimeArray(Calendar[] v)
   {
      return v;
   }
   /***
    public byte[][] echoBase64BinaryArray(byte[][] v)
    {
    return v;
    }
    public byte[][] echoHexBinaryArray(byte[][] v)
    {
    return v;
    }

    public void echoVoid()
    {
    }
    ***/

   public void ejbCreate()
   {
   }

   public void ejbActivate()
   {
   }

   public void ejbRemove()
   {
   }

   public void ejbPassivate()
   {
   }

   public void setSessionContext(SessionContext sc)
   {
   }
}
