/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.marshalltest;

// $Id:AbstractRpcTestBase.java,v 1.0, 2005-06-24 18:43:25Z, Robert Worsnop$

import org.jboss.test.webservice.WebserviceTestBase;
import org.jboss.test.webservice.marshalltest.types.Bean;

import javax.xml.namespace.QName;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

/**
 * Tests of the ws4ee marshalling
 *
 * @author Thomas.Diesler@jboss.org
 * @since 09-May-2004
 */
public abstract class AbstractRpcTestBase extends WebserviceTestBase
{
   protected static MarshallRpcServiceInterface rpcPort;

   /**
    * Construct the test case with a given name
    */
   public AbstractRpcTestBase(String name)
   {
      super(name);
   }

   public void testEchoString() throws Exception
   {
      Object ret = rpcPort.echoString("Hello");
      assertEquals("Hello", ret);

      ret = rpcPort.echoString("");
      assertEquals("", ret);

      ret = rpcPort.echoString(null);
      assertNull(ret);
   }

   public void testEchoInteger() throws Exception
   {
      Object ret = rpcPort.echoInteger(new BigInteger("100"));
      assertEquals(new BigInteger("100"), ret);

      ret = rpcPort.echoInteger(null);
      assertNull(ret);
   }

   public void testEchoInt() throws Exception
   {
      int ret = rpcPort.echoInt(100);
      assertEquals(100, ret);
   }

   public void testEchoLong() throws Exception
   {
      long ret = rpcPort.echoLong(100);
      assertEquals(100, ret);
   }

   public void testEchoShort() throws Exception
   {
      short ret = rpcPort.echoShort((short)100);
      assertEquals((short)100, ret);
   }

   public void testEchoDecimal() throws Exception
   {
      Object ret = rpcPort.echoDecimal(new BigDecimal("100"));
      assertEquals(new BigDecimal("100"), ret);

      ret = rpcPort.echoDecimal(null);
      assertNull(ret);
   }

   public void testEchoFloat() throws Exception
   {
      float ret = rpcPort.echoFloat((float)100.3);
      assertEquals(100.3, ret, 0.0001);
   }

   public void testEchoDouble() throws Exception
   {
      double ret = rpcPort.echoDouble(100.7);
      assertEquals(100.7, ret, 0.0001);
   }

   public void testEchoBoolean() throws Exception
   {
      boolean ret = rpcPort.echoBoolean(true);
      assertEquals(true, ret);
   }

   public void testEchoByte() throws Exception
   {
      byte ret = rpcPort.echoByte((byte)0x6a);
      assertEquals((byte)0x6a, ret);
   }

   public void testEchoQName() throws Exception
   {
      Object ret = rpcPort.echoQName(new QName("uri", "local"));
      assertEquals(new QName("uri", "local"), ret);

      ret = rpcPort.echoQName(null);
      assertNull(ret);
   }

   public void testEchoDateTimeCalendar() throws Exception
   {
      Calendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT+1"));
      Calendar ret = (Calendar)rpcPort.echoDateTimeCalendar(cal);
      assertEquals(cal.getTime(), ret.getTime());
      assertEquals(cal.get(Calendar.ZONE_OFFSET), ret.get(Calendar.ZONE_OFFSET));

      ret = rpcPort.echoDateTimeCalendar(null);
      assertNull(ret);
   }

   public void testEchoDateTimeDate() throws Exception
   {
      Date date = new Date();
      Date ret = rpcPort.echoDateTimeDate(date);
      assertEquals(date.getTime(), ret.getTime());

      ret = rpcPort.echoDateTimeDate(null);
      assertNull(ret);
   }

   public void testEchoDateCalendar() throws Exception
   {
      Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("Asia/Hong_Kong"));
      cal.clear();
      cal.set(2004, 11, 21);
      Calendar ret = rpcPort.echoDateCalendar(cal);
      assertEquals(cal.getTime().getTime(), ret.getTime().getTime());
      assertEquals(cal.get(Calendar.ZONE_OFFSET), ret.get(Calendar.ZONE_OFFSET));

      ret = rpcPort.echoDateCalendar(null);
      assertNull(ret);
   }

   public void testEchoDateDate() throws Exception
   {
      Calendar cal = Calendar.getInstance();
      cal.clear();
      cal.set(2004, 11, 21);
      Date ret = rpcPort.echoDateDate(cal.getTime());
      assertEquals(cal.getTime().getTime(), ret.getTime());

      ret = rpcPort.echoDateDate(null);
      assertNull(ret);
   }

   public void testEchoBase64Binary() throws Exception
   {
      byte[] bytes = "Hello world!".getBytes();
      Object ret = rpcPort.echoBase64Binary(bytes);
      assertEquals("Hello world!", new String((byte[])ret));

      ret = rpcPort.echoBase64Binary(null);
      assertNull(ret);
   }

   public void testEchoHexBinary() throws Exception
   {
      byte[] bytes = "Hello world!".getBytes();
      Object ret = rpcPort.echoHexBinary(bytes);
      assertEquals("Hello world!", new String((byte[])ret));

      ret = rpcPort.echoHexBinary(null);
      assertNull(ret);
   }

   public void testEchoBean() throws Exception
   {
      Bean bean = new Bean();
      bean.setX(1);
      bean.setY(2);
      bean.setBase64("base64".getBytes());

      Object ret = rpcPort.echoBean(bean);
      assertEquals(bean, ret);

      ret = rpcPort.echoBean(null);
      assertNull(ret);
   }

   // See: http://jira.jboss.com/jira/browse/JBWS-30
   public void testEchoBeanNullProperties() throws Exception
   {
      Bean bean = new Bean();

      // Test null byte array
      Object ret = rpcPort.echoBean(bean);
      assertEquals(bean, ret);

      // Test empty byte array
      bean.setBase64(new byte[0]);

      ret = rpcPort.echoBean(bean);
      assertEquals(bean, ret);
   }

   public void testEchoStringArray() throws Exception
   {
      String[] arr = new String[]{"Hello", "world", "!"};
      Object ret = rpcPort.echoStringArray(arr);
      assertEquals(Arrays.asList(arr), Arrays.asList((String[])ret));
   }

   public void testEchoIntegerArray() throws Exception
   {
      BigInteger[] arr = new BigInteger[]{new BigInteger("1"), new BigInteger("0"), new BigInteger("-1")};
      Object ret = rpcPort.echoIntegerArray(arr);
      assertEquals(Arrays.asList(arr), Arrays.asList((BigInteger[])ret));
   }

   public void testEchoIntArray() throws Exception
   {
      int[] arr = new int[]{1, 0, -1};
      int[] ret = (int[])rpcPort.echoIntArray(arr);
      for (int i = 0; i < arr.length; i++)
         assertEquals(arr[i], ret[i]);
   }

   public void testEchoLongArray() throws Exception
   {
      long[] arr = new long[]{1, 0, -1};
      long[] ret = (long[])rpcPort.echoLongArray(arr);
      for (int i = 0; i < arr.length; i++)
         assertEquals(arr[i], ret[i]);
   }

   public void testEchoShortArray() throws Exception
   {
      short[] arr = new short[]{1, 0, -1};
      short[] ret = (short[])rpcPort.echoShortArray(arr);
      for (int i = 0; i < arr.length; i++)
         assertEquals(arr[i], ret[i]);
   }

   public void testEchoDecimalArray() throws Exception
   {
      BigDecimal[] arr = new BigDecimal[]{new BigDecimal("1"), new BigDecimal("0"), new BigDecimal("-1")};
      Object ret = rpcPort.echoDecimalArray(arr);
      assertEquals(Arrays.asList(arr), Arrays.asList((BigDecimal[])ret));
   }

   public void testEchoFloatArray() throws Exception
   {
      float[] arr = new float[]{1, 0, -1};
      float[] ret = (float[])rpcPort.echoFloatArray(arr);
      for (int i = 0; i < arr.length; i++)
         assertEquals(arr[i], ret[i], 0);
   }

   public void testEchoDoubleArray() throws Exception
   {
      double[] arr = new double[]{1, 0, -1};
      double[] ret = (double[])rpcPort.echoDoubleArray(arr);
      for (int i = 0; i < arr.length; i++)
         assertEquals(arr[i], ret[i], 0);
   }

   public void testEchoBooleanArray() throws Exception
   {
      boolean[] arr = new boolean[]{true, false, true};
      boolean[] ret = (boolean[])rpcPort.echoBooleanArray(arr);
      for (int i = 0; i < arr.length; i++)
         assertEquals(arr[i], ret[i]);
   }

   public void testEchoByteArray() throws Exception
   {
      byte[] arr = new byte[]{1, 0, -1};
      byte[] ret = (byte[])rpcPort.echoByteArray(arr);
      for (int i = 0; i < arr.length; i++)
         assertEquals(arr[i], ret[i]);
   }

   public void testEchoQNameArray() throws Exception
   {
      QName[] arr = new QName[]{new QName("uri", "loc1"), new QName("uri", "loc2"), new QName("uri", "loc3")};
      QName[] ret = (QName[])rpcPort.echoQNameArray(arr);
      for (int i = 0; i < arr.length; i++)
         assertEquals(arr[i], ret[i]);
      assertEquals(Arrays.asList(arr), Arrays.asList((QName[])ret));
   }

   public void testEchoDateTimeArray() throws Exception
   {
      Calendar cal1 = new GregorianCalendar(2004, 5, 10);
      Calendar cal2 = new GregorianCalendar(2004, 5, 11);
      Calendar cal3 = new GregorianCalendar(2004, 5, 12);
      Calendar[] arr = new Calendar[]{cal1, cal2, cal3};
      Calendar[] ret = (Calendar[])rpcPort.echoDateTimeArray(arr);

      // Note, the TimeZone is not encoded, so the server might change it
      for (int i = 0; i < arr.length; i++)
         assertEquals(arr[i].getTime(), ret[i].getTime());
   }
}
