/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.jbws84;

// $Id:Message.java,v 1.0, 2005-06-24 19:12:07Z, Robert Worsnop$

import javax.xml.soap.SOAPElement;
import java.rmi.Remote;
import java.rmi.RemoteException;

/**
 * @author Thomas.Diesler@jboss.org
 * @since 26-Nov-2004
 */
public interface Message extends Remote
{
   static final String NAMESPACE_URI = "http://org.jboss.test.webservice/jbws84";
   static final String PREFIX = "ns1";

   String request =
           "<ns1:Order xmlns:ns1='http://org.jboss.test.webservice/jbws84'>" +
           "  <Customer>Kermit</Customer>" +
           "  <Item>Ferrari</Item>" +
           "</ns1:Order>";

   String response =
           "<ns1:Response xmlns:ns1='http://org.jboss.test.webservice/jbws84'>" +
           "  <POID>12345</POID>" +
           "  <Status>ok</Status>" +
           "</ns1:Response>";

   public SOAPElement processSOAPElement(SOAPElement msg) throws RemoteException;
}
