/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.jbws70;

// $Id:JBWS70TestCase.java,v 1.0, 2005-06-24 19:09:16Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.test.webservice.WebserviceTestBase;

import javax.naming.InitialContext;
import javax.xml.rpc.Service;

/**
 *  It appears that web services methods that take no parameters is incompatible with document literal style.
 *
 * http://jira.jboss.com/jira/browse/JBWS-70
 *
 * @author Thomas.Diesler@jboss.org
 * @since 08-Feb-2005
 */
public class JBWS70TestCase extends WebserviceTestBase
{
   /** Construct the test case with a given name
    */
   public JBWS70TestCase(String name)
   {
      super(name);
   }

   /** Deploy the test */
   public static Test suite() throws Exception
   {
      return getDeploySetup(JBWS70TestCase.class, "ws4ee-jbws70.war, ws4ee-jbws70-client.jar");
   }

   /**
    * Test JSE endpoint
    */
   public void testEndpoint() throws Exception
   {
      InitialContext iniCtx = getClientContext();
      Service service = (Service)iniCtx.lookup("java:comp/env/service/HelloService");
      Hello hello = (Hello)service.getPort(Hello.class);

      assertEquals(Hello.VERSION, hello.getVersion());
   }
}
