/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.webservice.jbws68;

import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;

public class ClientHandler extends GenericHandler
{
   protected QName[] headers;

   public QName[] getHeaders()
   {
      return headers;
   }

   public boolean handleRequest(MessageContext msgContext)
   {
      try
      {
         SOAPMessageContext soapContext = (SOAPMessageContext)msgContext;
         SOAPMessage soapMessage = soapContext.getMessage();
         SOAPBody soapBody = soapMessage.getSOAPBody();
         SOAPElement rpcElement = (SOAPElement)soapBody.getChildElements().next();

         SOAPFactory factory = SOAPFactory.newInstance();
         Name rpcName = factory.createName("echoUserType", "ns1", "http://org.jboss.test.webservice/jbws68");
         if (rpcName.equals(rpcElement.getElementName()) == false)
            throw new IllegalStateException("Invalid rpc name: " + rpcElement.getElementName());

         SOAPElement paramElement = (SOAPElement)rpcElement.getChildElements().next();
         Name paramName = factory.createName("UserType_1");
         if (paramName.equals(paramElement.getElementName()) == false)
            throw new IllegalStateException("Invalid param name: " + paramElement.getElementName());

         /* SOAPElement view of RPCParam not implemented

         SOAPElement msgElement = (SOAPElement)paramElement.getChildElements().next();
         Name msgName = factory.createName("msg");
         if (msgName.equals(msgElement.getElementName()) == false)
            throw new IllegalStateException("Invalid msg name: " + msgElement.getElementName());

         String value = msgElement.getValue();
         msgElement.setValue(value + "|req-ok");
         */

         return true;
      }
      catch (SOAPException e)
      {
         throw new IllegalArgumentException(e.toString());
      }
   }

   public boolean handleResponse(MessageContext msgContext)
   {
      try
      {
         SOAPMessageContext soapContext = (SOAPMessageContext)msgContext;
         SOAPMessage soapMessage = soapContext.getMessage();
         SOAPBody soapBody = soapMessage.getSOAPBody();
         SOAPElement rpcElement = (SOAPElement)soapBody.getChildElements().next();

         SOAPFactory factory = SOAPFactory.newInstance();
         Name rpcName = factory.createName("echoUserTypeResponse", "ns1", "http://org.jboss.test.webservice/jbws68");
         if (rpcName.equals(rpcElement.getElementName()) == false)
            throw new IllegalStateException("Invalid rpc name: " + rpcElement.getElementName());

         SOAPElement paramElement = (SOAPElement)rpcElement.getChildElements().next();
         Name paramName = factory.createName("result");
         if (paramName.equals(paramElement.getElementName()) == false)
            throw new IllegalStateException("Invalid param name: " + paramElement.getElementName());

         /* SOAPElement view of RPCParam not implemented

         SOAPElement msgElement = (SOAPElement)paramElement.getChildElements().next();
         Name msgName = factory.createName("msg");
         if (msgName.equals(msgElement.getElementName()) == false)
            throw new IllegalStateException("Invalid msg name: " + msgElement.getElementName());

         String value = msgElement.getValue();
         msgElement.setValue(value + "|res-ok");
         */

         return true;
      }
      catch (SOAPException e)
      {
         throw new IllegalArgumentException(e.toString());
      }
   }
}
