/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.jbws64;

// $Id:JBWS64TestCase.java,v 1.0, 2005-06-24 19:09:15Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.test.JBossTestCase;

import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPMessage;
import java.io.ByteArrayInputStream;

/**
 * Axis-1.2RC2 client may send messages like this
 *
 * <soapenv:Envelope>
 *  <soapenv:Body>
 *   <publish xmlns="http://webservices.est.useme.etish.com">
 *    <in0 xmlns="">joel</in0>
 *     <in1 xmlns="">secret</in1>
 *     <in2 xmlns="">1</in2>
 *     <in3 xmlns="">6</in3>
 *     <in4 xmlns="">2</in4>
 *    </publish>
 *   </soapenv:Body>
 * </soapenv:Envelope>
 *
 * http://jira.jboss.com/jira/browse/JBWS-64
 *
 * @author Thomas.Diesler@jboss.org
 * @since 08-Feb-2005
 */
public class JBWS64TestCase extends JBossTestCase
{
   /** Construct the test case with a given name
    */
   public JBWS64TestCase(String name)
   {
      super(name);
   }

   /** Deploy the test */
   public static Test suite() throws Exception
   {
      return getDeploySetup(JBWS64TestCase.class, "ws4ee-jbws64.war");
   }

   /**
    * Test JSE endpoint
    */
   public void testEndpoint() throws Exception
   {
      String reqMsgStr =
              "<soapenv:Envelope" +
              "    xmlns:soapenv='http://schemas.xmlsoap.org/soap/envelope/'" +
              "    xmlns:xsd='http://www.w3.org/2001/XMLSchema'" +
              "    xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'>" +
              "  <soapenv:Body>" +
              "    <publish xmlns='http://webservices.est.useme.etish.com'>" +
              "       <in0 xmlns=''>joel</in0>" +
              "       <in1 xmlns=''>secret</in1>" +
              "       <in2 xmlns=''>1</in2>" +
              "       <in3 xmlns=''>6</in3>" +
              "       <in4 xmlns=''>2</in4>" +
              "     </publish>" +
              "  </soapenv:Body>" +
              "</soapenv:Envelope>";

      MessageFactory msgFactory = MessageFactory.newInstance();
      SOAPMessage reqMsg = msgFactory.createMessage(null, new ByteArrayInputStream(reqMsgStr.getBytes()));

      SOAPConnectionFactory factory = SOAPConnectionFactory.newInstance();
      SOAPConnection con = factory.createConnection();
      SOAPMessage resMsg = con.call(reqMsg, "http://" + getServerHost() + ":8080/ws4ee-jbws64");

      SOAPBody soapBody = resMsg.getSOAPBody();
      SOAPElement soapBodyElement = (SOAPElement)soapBody.getChildElements().next();
      SOAPElement soapElement = (SOAPElement)soapBodyElement.getChildElements().next();
      assertEquals("joel,secret,1,6,2", soapElement.getValue());
   }
}
