/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.jbws128;

// $Id:JBWS128TestCase.java,v 1.0, 2005-06-24 19:09:15Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.test.webservice.WebserviceTestBase;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;

/** Test to load client wsdl from war inside an ear
 *
 *  http://jira.jboss.com/jira/browse/JBWS-128
 *
 * @author Thomas.Diesler@jboss.org
 * @since 05-Mar-2005
 */
public class JBWS128TestCase extends WebserviceTestBase
{
   /** Construct the test case with a given name
    */
   public JBWS128TestCase(String name)
   {
      super(name);
   }

   /** Deploy the test */
   public static Test suite() throws Exception
   {
      return getDeploySetup(JBWS128TestCase.class, "ws4ee-jbws128.ear");
   }

   /**
    * Test JSE endpoint
    */
   public void testEndpoint() throws Exception
   {
      URL url = new URL("http://" + getServerHost() + ":8080/ws4ee-jbws128-client");
      BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
      String out = reader.readLine();

      assertEquals("Kermit", out);
   }
}
