/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.jbas897;

// $Id:JBAS897TestCase.java,v 1.0, 2005-06-24 19:07:56Z, Robert Worsnop$

import org.jboss.test.JBossTestCase;

import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceFactory;
import java.net.URL;

/**
 * I made a typo in my ejb-jar.xml file so it didn't match the
 * <ejb-link> within my webservices.xml file. No complaint
 * from JBoss on deployment on this.

 * http://jira.jboss.com/jira/browse/JBAS-897
 *
 * @author Thomas.Diesler@jboss.org
 * @since 04-Feb-2005
 */
public class JBAS897TestCase extends JBossTestCase
{
   private String NAMESPACE = "http://org.jboss.test.webservice/jbas897";
   private QName SERVICE_NAME = new QName(NAMESPACE, "HelloService");

   /**
    * Construct the test case with a given name
    */
   public JBAS897TestCase(String name)
   {
      super(name);
   }

   /**
    * Test JSE endpoint
    */
   public void testJSEEndpoint() throws Exception
   {
      deploy("ws4ee-jbas897.war");

      try
      {
         ServiceFactory serviceFactory = ServiceFactory.newInstance();
         Service service = serviceFactory.createService(new URL("http://" + getServerHost() + ":8080/ws4ee-jbas897/HelloJSE?wsdl"), SERVICE_NAME);
         Call call = (Call)service.createCall(new QName(NAMESPACE, "HelloPort"), "sayHello");
         String retstr = (String)call.invoke(new Object[]{"Hello"});
         assertEquals("'Hello' to you too!", retstr);
      }
      finally
      {
         undeploy("ws4ee-jbas897.war");
      }
   }

   /**
    * Test JSE endpoint with invalid deployment
    */
   public void testJSEEndpointFail() throws Exception
   {
      try
      {
         deploy("ws4ee-jbas897-fail.war");
         fail("deployment should fail");
      }
      catch (Exception e)
      {
         // ignore
      }

      testJSEEndpoint();
   }

   /**
    * Test EJB endpoint
    */
   public void testEJBEndpoint() throws Exception
   {
      deploy("ws4ee-jbas897.jar");

      try
      {
         ServiceFactory serviceFactory = ServiceFactory.newInstance();
         Service service = serviceFactory.createService(new URL("http://" + getServerHost() + ":8080/ws4ee-jbas897/HelloEJB?wsdl"), SERVICE_NAME);
         Call call = (Call)service.createCall(new QName(NAMESPACE, "HelloPort"), "sayHello");
         String retstr = (String)call.invoke(new Object[]{"Hello"});
         assertEquals("'Hello' to you too!", retstr);
      }
      finally
      {
         undeploy("ws4ee-jbas897.jar");
      }
   }

   /**
    * Test EJB endpoint
    */
   public void testEJBEndpointFail() throws Exception
   {
      // Unlike JSE, the MainDeployer.deploy() does not fail for EJBs
      // Not to worry, the deployment should be taken down from the ServiceDeployer
      deploy("ws4ee-jbas897-fail.jar");

      testEJBEndpoint();
   }
}
