/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.header;

import org.jboss.logging.Logger;
import org.jboss.util.id.UID;

import java.rmi.RemoteException;

/**
 * @author Thomas.Diesler@jboss.org
 * @since 26-Nov-2004
 */
public class BeanHeaderEndpointImpl implements BeanHeaderEndpoint
{
   // provide logging
   private final Logger log = Logger.getLogger(BeanHeaderEndpointImpl.class);

   public boolean doStuff(String parameter, SessionHeader header) throws RemoteException
   {
      if (parameter == null)
         throw new IllegalArgumentException("Null parameter");

      String username = header.getUsername();
      String sessionID = header.getSessionID();

      log.info("username: " + username);
      log.info("sessionID: " + sessionID);

      if (sessionID == null)
         header.setSessionID(UID.asString());

      return true;
   }
}
