/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.webservice.handlerflow;

import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import java.rmi.RemoteException;

public class HelloBean implements SessionBean
{
   private Service service;

   public String[] sayHello(String input) throws RemoteException
   {
      try
      {
         HandlerTracker.clear();
         HelloEndpoint sei = (HelloEndpoint)service.getPort(HelloEndpoint.class);
         String msg = sei.sayHello(input);
         HandlerTracker.trackMessage("ejb: " + msg);
         return HandlerTracker.getProtocol();
      }
      catch (ServiceException e)
      {
         throw new EJBException(e);
      }
   }

   // EJB life cycle methods *******************************************************************************************

   public void ejbCreate()
   {
   }

   public void ejbRemove()
   {
   }

   public void ejbActivate()
   {
   }

   public void ejbPassivate()
   {
   }

   public void setSessionContext(SessionContext sc)
   {
      try
      {
         InitialContext iniCtx = new InitialContext();
         service = (Service)iniCtx.lookup("java:comp/env/service/HelloService");
      }
      catch (NamingException e)
      {
         throw new EJBException(e);
      }
   }
}
