/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.handlerflow;

// $Id:HandlerFlowTestCase.java,v 1.0, 2005-06-24 19:04:58Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.test.webservice.WebserviceTestBase;

import javax.naming.InitialContext;
import java.util.Arrays;
import java.util.List;

/**
 * The HelloEjb is the web service client conecting to HelloJSE.
 * Both the client and the server have handlers configured, we test
 * the flow of handler invocations.
 *
 * @author Thomas.Diesler@jboss.org
 * @since 12-May-2004
 */
public class HandlerFlowTestCase extends WebserviceTestBase
{

   /**
    * Construct the test case with a given name
    */
   public HandlerFlowTestCase(String name)
   {
      super(name);
   }

   /**
    * deploy the test archives
    */
   public static Test suite() throws Exception
   {
      return getDeploySetup(HandlerFlowTestCase.class, "ws4ee-handlerflow.jar, ws4ee-handlerflow.war");
   }

   /**
    * Call the ejb and verify the hnder tracker protocol
    */
   public void testHandlerFlow() throws Exception
   {
      // test direct EJB access
      InitialContext iniCtx = getClientContext();
      HelloHome home = (HelloHome)iniCtx.lookup("ejb/HelloEjb");
      HelloRemote ejb = home.create();

      List protocol = Arrays.asList(ejb.sayHello("Hello"));

      String[] exp = {
         "ClientHandler1 init",
         "ClientHandler2 init",
         "ClientHandler1 handleRequest",
         "ClientHandler2 handleRequest",
         "ServerHandler1 init",
         "ServerHandler2 init",
         "ServerHandler1 handleRequest",
         "ServerHandler2 handleRequest",
         "jse: 'Hello' to you too!",
         "ServerHandler2 handleResponse",
         "ServerHandler1 handleResponse",
         "ClientHandler2 handleResponse",
         "ClientHandler1 handleResponse",
         "ejb: 'Hello' to you too!"
      };
      assertEquals("Wrong number of entries: " + protocol, exp.length, protocol.size());

      for (int i = 0; i < protocol.size(); i++)
      {
         String msg = (String)protocol.get(i);
         boolean equals = msg.startsWith(exp[i]);
         assertTrue("Wrong entry: " + msg + " in " + protocol, equals);

      }
   }
}
