/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.webservice.handlerflow;

import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;

public class HandlerBase extends GenericHandler
{
   protected QName[] headers;

   public QName[] getHeaders()
   {
      return headers;
   }

   public void init(HandlerInfo config)
   {
      headers = config.getHeaders();
      HandlerTracker.trackInit(this);
   }

   public void destroy()
   {
      HandlerTracker.trackDestroy(this);
   }

   public boolean handleRequest(MessageContext msgContext)
   {
      HandlerTracker.trackHandleRequest(this);
      return true;
   }

   public boolean handleResponse(MessageContext msgContext)
   {
      HandlerTracker.trackHandleResponse(this);
      return true;
   }

   public boolean handleFault(MessageContext msgContext)
   {
      HandlerTracker.trackHandleFault(this);
      return true;
   }
}
