/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.attachment;

// $Id:AttachmentImpl.java,v 1.0, 2005-06-24 18:46:10Z, Robert Worsnop$

import javax.activation.DataHandler;
import javax.mail.BodyPart;
import javax.mail.internet.MimeMultipart;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.server.ServiceLifecycle;
import javax.xml.rpc.server.ServletEndpointContext;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import java.awt.*;
import java.rmi.RemoteException;
import java.util.Iterator;

/**
 * Service Endpoint for the MIME mapping required by JAXRPC-1.1
 *
 * image/gif         java.awt.Image
 * image/jpeg        java.awt.Image
 * text/plain        java.lang.String
 * multipart/*       javax.mail.internet.MimeMultipart
 * text/xml          javax.xml.transform.Source
 * application/xml   javax.xml.transform.Source
 *
 * @author Thomas.Diesler@jboss.org
 * @since Nov 17, 2004
 */
public class AttachmentImpl implements Attachment, ServiceLifecycle
{
   private ServletEndpointContext context;

   /** Service endpoint method for image/gif */
   public String sendMimeImageGIF(String message, Object mimepart) throws RemoteException
   {
      StringBuffer buffer = new StringBuffer();

      validateStringMessage(buffer, message);

      String expContentType = "image/gif";
      validateAttachmentPart(buffer, expContentType, mimepart);

      String resultStr = getResultStr(buffer, expContentType);
      return resultStr;
   }

   /** Service endpoint method for image/jpeg */
   public String sendMimeImageJPEG(String message, Object mimepart) throws RemoteException
   {
      StringBuffer buffer = new StringBuffer();

      validateStringMessage(buffer, message);

      String expContentType = "image/jpeg";
      validateAttachmentPart(buffer, expContentType, mimepart);

      String resultStr = getResultStr(buffer, expContentType);
      return resultStr;
   }

   /** Service endpoint method for text/plain */
   public String sendMimeTextPlain(String message, Object mimepart) throws RemoteException
   {
      StringBuffer buffer = new StringBuffer();

      validateStringMessage(buffer, message);

      String expContentType = "text/plain";
      validateAttachmentPart(buffer, expContentType, mimepart);

      String resultStr = getResultStr(buffer, expContentType);
      return resultStr;
   }

   /** Service endpoint method for multipart/* */
   public String sendMimeMultipart(String message, Object mimepart) throws RemoteException
   {
      StringBuffer buffer = new StringBuffer();

      validateStringMessage(buffer, message);

      String expContentType = "multipart/*";
      validateAttachmentPart(buffer, expContentType, mimepart);

      String resultStr = getResultStr(buffer, expContentType);
      return resultStr;
   }

   /** Service endpoint method for text/xml */
   public String sendMimeTextXML(String message, Object mimepart) throws RemoteException
   {
      StringBuffer buffer = new StringBuffer();

      validateStringMessage(buffer, message);

      String expContentType = "text/xml";
      validateAttachmentPart(buffer, expContentType, mimepart);

      String resultStr = getResultStr(buffer, expContentType);
      return resultStr;
   }

   /** Service endpoint method for application/xml */
   public String sendMimeApplicationXML(String message, Object mimepart) throws RemoteException
   {
      StringBuffer buffer = new StringBuffer();

      validateStringMessage(buffer, message);

      String expContentType = "application/xml";
      validateAttachmentPart(buffer, expContentType, mimepart);

      String resultStr = getResultStr(buffer, expContentType);
      return resultStr;
   }

   /** Service endpoint method for image/gif */
   public Object echoMimeImageGIF(Object mimepart) throws RemoteException
   {
      StringBuffer buffer = new StringBuffer();
      String expContentType = "image/gif";
      validateAttachmentPart(buffer, expContentType, mimepart);

      return mimepart;
   }

   /** Service endpoint method for image/jpeg */
   public Object echoMimeImageJPEG(Object mimepart) throws RemoteException
   {
      StringBuffer buffer = new StringBuffer();
      String expContentType = "image/jpeg";
      validateAttachmentPart(buffer, expContentType, mimepart);

      return mimepart;
   }

   /** Service endpoint method for text/plain */
   public Object echoMimeTextPlain(Object mimepart) throws RemoteException
   {
      StringBuffer buffer = new StringBuffer();
      String expContentType = "text/plain";
      validateAttachmentPart(buffer, expContentType, mimepart);

      return mimepart;
   }

   /** Service endpoint method for multipart/* */
   public Object echoMimeMultipart(Object mimepart) throws RemoteException
   {
      StringBuffer buffer = new StringBuffer();
      String expContentType = "multipart/*";
      validateAttachmentPart(buffer, expContentType, mimepart);

      return mimepart;
   }

   /** Service endpoint method for text/xml */
   public Object echoMimeTextXML(Object mimepart) throws RemoteException
   {
      StringBuffer buffer = new StringBuffer();
      String expContentType = "text/xml";
      validateAttachmentPart(buffer, expContentType, mimepart);

      return mimepart;
   }

   /** Service endpoint method for application/xml */
   public Source echoMimeApplicationXML(Source mimepart) throws RemoteException
   {
      StringBuffer buffer = new StringBuffer();
      String expContentType = "application/xml";
      validateAttachmentPart(buffer, expContentType, mimepart);

      return mimepart;
   }

   public DataHandler echoHandler(DataHandler mimepart) throws RemoteException
   {
      return mimepart;
   }

   private void validateStringMessage(StringBuffer buffer, String message)
   {
      if ("Some text message".equals(message) == false)
         buffer.append("[message=" + message + "]");
   }

   private void validateAttachmentPart(StringBuffer buffer, String expContentType, Object mimepart)
   {
      SOAPMessageContext msgContext = (SOAPMessageContext)context.getMessageContext();
      SOAPMessage soapMessage = msgContext.getMessage();

      Iterator attachments = soapMessage.getAttachments();
      if (attachments.hasNext())
      {
         AttachmentPart ap = (AttachmentPart)attachments.next();
         String contentType = ap.getContentType();

         if (expContentType.equals("multipart/*"))
         {
            if (contentType.startsWith("multipart/") == false)
               buffer.append("[contentType=" + contentType + "]");
         }
         else if (expContentType.equals("text/xml"))
         {
            if (contentType.equals("text/xml") == false && contentType.equals("application/xml") == false)
               buffer.append("[contentType=" + contentType + "]");
         }
         else
         {
            if (contentType.equals(expContentType) == false)
               buffer.append("[contentType=" + contentType + "]");
         }
         validateSinglePart(buffer, expContentType, ap);
      }
      else
      {
         buffer.append("[no attachments]");
      }

      validateSinglePart(buffer, expContentType, mimepart);
   }

   private void validateSinglePart(StringBuffer buffer, String contentType, Object content)
   {
      try
      {
         if (content instanceof AttachmentPart)
            content = ((AttachmentPart)content).getContent();

         if (contentType.equals("image/gif") || contentType.equals("image/jpeg"))
         {
            if ((content instanceof Image) == false)
               buffer.append("[content=" + content + "]");
         }
         else if (contentType.equals("text/plain"))
         {
            if ((content instanceof String) == false)
               buffer.append("[content=" + content + "]");
         }
         else if (contentType.startsWith("multipart/"))
         {
            if ((content instanceof MimeMultipart) == false)
            {
               buffer.append("[content=" + content + "]");
            }
            else
            {
               MimeMultipart mmp = (MimeMultipart)content;

               int mmpCount = mmp.getCount();
               if (mmpCount < 1)
                  buffer.append("[count=" + mmpCount + "]");

               for (int i = 0; i < mmpCount; i++)
               {
                  BodyPart bp = mmp.getBodyPart(i);
                  String bpct = bp.getContentType();
                  Object bpc = bp.getContent();
                  validateSinglePart(buffer, bpct, bpc);
               }
            }
         }
         else if (contentType.equals("text/xml") || contentType.equals("application/xml"))
         {
            if ((content instanceof Source) == false)
               buffer.append("[content=" + content + "]");
         }
         else
         {
            throw new IllegalArgumentException("Unsupported mime type: " + contentType);
         }
      }
      catch (Exception e)
      {
         buffer.append("[" + e + "]");
      }
   }

   private String getResultStr(StringBuffer buffer, String expContentType)
   {
      String retStr = (buffer.length() == 0 ? "[pass]" : buffer.toString());
      System.out.println(expContentType + ": " + retStr);
      return retStr;
   }

   // ServiceLifecycle *******************************************************************************************

   public void init(Object context) throws ServiceException
   {
      this.context = (ServletEndpointContext)context;
   }

   public void destroy()
   {
      this.context = null;
   }
}
