/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.webservice;

import org.jboss.test.JBossTestCase;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import java.util.Properties;

/** Common functionality for web services test cases.
 *
 * @author Thomas.Diesler@jboss.org
 * @version $Revision:1$
 */
public class WebserviceTestBase extends JBossTestCase
{
   public WebserviceTestBase(String name)
   {
      super(name);
   }

   /**
    * Get the client's env context, see tracker [840598] for details
    */
   protected InitialContext getClientContext() throws NamingException
   {
      Properties env = new Properties();
      env.setProperty(Context.INITIAL_CONTEXT_FACTORY, "org.jnp.interfaces.NamingContextFactory");
      env.setProperty(Context.URL_PKG_PREFIXES, "org.jboss.naming.client");
      env.setProperty(Context.PROVIDER_URL, "jnp://" + getServerHost() + ":1099");
      env.setProperty("j2ee.clientName", "ws4ee-client");
      return new InitialContext(env);
   }
}
