/*
 * JBoss, the OpenSource WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.web.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.Principal;
import javax.naming.InitialContext;
import javax.naming.Context;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jboss.test.web.interfaces.RunAsTargetLocalHome;
import org.jboss.test.web.interfaces.RunAsTargetLocal;
import org.jboss.logging.Logger;

/** A servlet deployed under an unrestricted path that invokes the checkRunAs
 * method on a secured RunAsTargetLocal EJB.
 *
 * @author  Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class UnsecureRunAsServlet extends HttpServlet
{
   Logger log = Logger.getLogger(UnsecureRunAsServlet.class);

   protected void processRequest(HttpServletRequest request, HttpServletResponse response)
      throws ServletException, IOException
   {
      String ejbName = request.getParameter("ejbName");
      try
      {
         InitialContext ctx = new InitialContext();
         RunAsTargetLocalHome home = null;
         Context enc = (Context) ctx.lookup("java:comp/env");
         home = (RunAsTargetLocalHome) enc.lookup(ejbName);
         RunAsTargetLocal bean = home.create();
         bean.checkRunAs();
      }
      catch(Exception e)
      {
         log.error("Access to checkRunAs failed", e);
         throw new ServletException("Access to checkRunAs failed", e);
      }

      Principal user = request.getUserPrincipal();
      PrintWriter out = response.getWriter();
      response.setContentType("text/html");
      out.println("<html>");
      out.println("<head><title>UnsecureRunAsServlet</title></head><body>");
      out.println("<h1>UnsecureRunAsServlet Accessed</h1>");
      out.println("<pre>You have accessed this servlet as user: "+user+"<br>");
      out.println("</pre>");
      out.println("</pre></body></html>");
      out.close();
   }

   protected void doGet(HttpServletRequest request, HttpServletResponse response)
      throws ServletException, IOException
   {
      processRequest(request, response);
   }
   
   protected void doPost(HttpServletRequest request, HttpServletResponse response)
      throws ServletException, IOException
   {
      processRequest(request, response);
   }

}
