/*
 * JBoss, the OpenSource J2EE WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.web.servlets;

import java.util.HashMap;
import java.util.Enumeration;
import javax.servlet.http.HttpSessionListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSession;

import org.jboss.logging.Logger;

/** A test HttpSessionListener that tracks which sessions have seen
 * create/destory events.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class TestSessionListener implements HttpSessionListener
{
   static Logger log = Logger.getLogger(TestSessionListener.class);
   static HashMap eventMap = new HashMap();

   static boolean wasCreated(String sessionID)
   {
      boolean[] events = (boolean[]) eventMap.get(sessionID);
      if( events == null )
         return false;
      return events[0];
   }
   static boolean wasDestroyed(String sessionID)
   {
      boolean[] events = (boolean[]) eventMap.get(sessionID);
      if( events == null )
         return false;
      return events[1];
   }

   public void sessionCreated(HttpSessionEvent event)
   {
      String sessionID = event.getSession().getId();
      log.info("sessionCreated, sessionID="+sessionID);
      boolean[] events = {true, false};
      eventMap.put(sessionID, events);
   }

   public void sessionDestroyed(HttpSessionEvent event)
   {
      String sessionID = event.getSession().getId();
      log.info("sessionDestroyed, sessionID="+sessionID);
      HttpSession session = event.getSession();
      Enumeration names = session.getAttributeNames();
      while( names.hasMoreElements() )
      {
         String name = (String) names.nextElement();
         log.info(name+"="+session.getAttribute(name));
      }      
      boolean[] events = (boolean[]) eventMap.get(sessionID);
      events[1] = true;
   }
}
