/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.web.servlets;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletResponse;
import javax.security.auth.Subject;
import javax.naming.NamingException;
import javax.naming.InitialContext;

import org.jboss.security.SubjectSecurityManager;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class SubjectFilter implements Filter
{
   public void init(FilterConfig filterConfig) throws ServletException
   {

   }

   public void doFilter(ServletRequest request, ServletResponse response,
      FilterChain filterChain)
      throws IOException, ServletException
   {
      HttpServletResponse httpResponse = (HttpServletResponse) response;
      try
      {
         Subject userSubject = getActiveSubject(httpResponse);
         if (userSubject == null)
            throw new ServletException("Active subject was null");
      }
      catch (NamingException e)
      {
         throw new ServletException("Failed to lookup active subject", e);
      }
      filterChain.doFilter(request, response);
   }

   public void destroy()
   {
   }

   protected Subject getActiveSubject(HttpServletResponse httpResponse)
      throws NamingException
   {
      InitialContext ctx = new InitialContext();
      SubjectSecurityManager mgr = (SubjectSecurityManager) ctx.lookup("java:comp/env/security/securityMgr");
      Subject s0 = mgr.getActiveSubject();
      httpResponse.addHeader("X-SubjectFilter-SubjectSecurityManager", s0.toString());
      Subject s1 = (Subject) ctx.lookup("java:comp/env/security/subject");
      httpResponse.addHeader("X-SubjectFilter-ENC", s1.toString());
      return s1;
   }
}
