/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.web.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.Principal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/** A secured servlet which is the target of a post from an unsecured servlet.
 * This validates that the post data is not lost when the original post is
 * redirected to the form auth login page.
 *
 * @author  Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class SecuredPostServlet extends HttpServlet
{
   protected void processRequest(HttpServletRequest request, HttpServletResponse response)
      throws ServletException, IOException
   {
      Principal user = request.getUserPrincipal();
      String path = request.getPathInfo();
      // Validate that there is an authenticated user
      if( user == null )
         throw new ServletException(path+" not secured");
      // Validate that the original post data was not lost
      String value = request.getParameter("checkParam");
      if( value == null || value.equals("123456") == false )
         throw new ServletException("Did not find checkParam=123456");

      PrintWriter out = response.getWriter();
      response.setContentType("text/html");
      out.println("<html>");
      out.println("<head><title>"+path+"</title></head><body>");
      out.println("<h1>"+path+" Accessed</h1>");
      out.println("You have accessed this servlet as user: " + user);
      out.println("</body></html>");
      out.close();
   }

   protected void doGet(HttpServletRequest request, HttpServletResponse response)
      throws ServletException, IOException
   {
      processRequest(request, response);
   }

   protected void doPost(HttpServletRequest request, HttpServletResponse response)
      throws ServletException, IOException
   {
      processRequest(request, response);
   }

}
