/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.txtimer.test;

// $Id:TransactionalTimerTestCase.java,v 1.0, 2005-06-24 19:18:06Z, Robert Worsnop$

import org.jboss.tm.TxManager;
import org.jboss.test.txtimer.test.TimedMockObject;
import org.jboss.test.txtimer.test.TimerTestBase;

import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.transaction.TransactionManager;

/**
 * Created by IntelliJ IDEA.
 * 
 * @author Thomas.Diesler@jboss.org
 * @since 07-Apr-2004
 */
public class TransactionalTimerTestCase extends TimerTestBase
{
   public TransactionalTimerTestCase(String name)
   {
      super(name);
   }

   public void testRollbackBeforeExpire() throws Exception
   {
      TransactionManager txManager = TxManager.getInstance();
      txManager.begin();

      TimedMockObject to = new TimedMockObject();
      TimerService service = createTimerService(to);

      service.createTimer(500, null);
      assertEquals("Expected one txtimer", 1, service.getTimers().size());
      txManager.rollback();
      sleep(1000);
      assertEquals("TimedObject called", 0, to.getCallCount());
      assertEquals("Expected no txtimer", 0, service.getTimers().size());
   }

   public void testRollbackAfterCreate() throws Exception
   {
      TransactionManager txManager = TxManager.getInstance();
      txManager.begin();

      TimedMockObject to = new TimedMockObject();
      TimerService service = createTimerService(to);
      service.createTimer(500, null);
      txManager.rollback();
      assertEquals("Expected no txtimer", 0, service.getTimers().size());
   }

   public void testRollbackCancel() throws Exception
   {
      TimedMockObject to = new TimedMockObject();
      TimerService service = createTimerService(to);
      Timer timer = service.createTimer(500, null);

      TransactionManager txManager = TxManager.getInstance();
      txManager.begin();
      timer.cancel();
      txManager.rollback();

      assertEquals("Expected one txtimer", 1, service.getTimers().size());
      sleep(1000);
      assertEquals("TimedObject not called", 1, to.getCallCount());
   }
}
