/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.txtimer.test;

// $Id:SimpleTimerTestCase.java,v 1.0, 2005-06-24 19:16:25Z, Robert Worsnop$

import javax.ejb.Timer;
import javax.ejb.TimerService;
import java.util.Date;

/**
 * Created by IntelliJ IDEA.
 * 
 * @author Thomas.Diesler@jboss.org
 * @since 07-Apr-2004
 */
public class SimpleTimerTestCase extends TimerTestBase
{
   public SimpleTimerTestCase(String name)
   {
      super(name);
   }

   public void testSingleEventDuration() throws Exception
   {
      TimedMockObject to = new TimedMockObject();
      TimerService service = createTimerService(to);

      service.createTimer(500, null);
      assertEquals("Expected one txtimer", 1, service.getTimers().size());
      sleep(1000);
      assertTrue("TimedObject not called", 1 == to.getCallCount());
      assertEquals("Expected no txtimer", 0, service.getTimers().size());
   }

   public void testSingleEventExpire() throws Exception
   {
      TimedMockObject to = new TimedMockObject();
      TimerService service = createTimerService(to);

      service.createTimer(new Date(System.currentTimeMillis() + 500), null);
      assertEquals("Expected one txtimer", 1, service.getTimers().size());
      sleep(1000);
      assertTrue("TimedObject not called", 1 == to.getCallCount());
      assertEquals("Expected no txtimer", 0, service.getTimers().size());
   }

   public void testMultipleEventDuration() throws Exception
   {
      TimedMockObject to = new TimedMockObject();
      TimerService service = createTimerService(to);

      Timer timer = service.createTimer(500, 1000, null);
      assertEquals("Expected one txtimer", 1, service.getTimers().size());
      sleep(2000);
      assertTrue("TimedObject not called enough", 1 < to.getCallCount());

      timer.cancel();
      assertEquals("Expected no txtimer", 0, service.getTimers().size());
   }

   public void testMultipleEventExpire() throws Exception
   {
      TimedMockObject to = new TimedMockObject();
      TimerService service = createTimerService(to);

      Timer timer = service.createTimer(new Date(System.currentTimeMillis() + 500), 500, null);
      assertEquals("Expected one txtimer", 1, service.getTimers().size());
      sleep(2000);
      assertTrue("TimedObject not called enough", 1 < to.getCallCount());

      timer.cancel();
      assertEquals("Expected no txtimer", 0, service.getTimers().size());
   }

}
