/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.txtimer.ejb;

import org.apache.log4j.Logger;

import javax.ejb.*;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.security.Principal;
import java.io.Serializable;

/**
 * Session Bean Timer Test
 *
 * @ejb.bean name="test/txtimer/TimerSession"
 *           display-name="Timer in Stateless Session Bean"
 *           type="Stateless"
 *           transaction-type="Container"
 *           view-type="both"
 *
 * @ejb.transaction type="Required"
 **/
public class TimerSessionBean
        implements SessionBean, TimedObject
{
   private static Logger log = Logger.getLogger(TimerSessionBean.class);

   private SessionContext context;

   // count calls to ejbTimeout
   private int callCount;

   // count calls to ejbTimeout
   private static int globalCallCount;

   // seen from ejbTimeout
   private Principal ejbTimeoutCaller;


   /**
    * @ejb.interface-method view-type="both"
    **/
   public void createTimer(long duration, long periode, Serializable info)
   {
      TimerService timerService = context.getTimerService();
      if (periode > 0)
         timerService.createTimer(duration, periode, info);
      else
         timerService.createTimer(duration, info);
   }

   /**
    * @ejb.interface-method view-type="both"
    **/
   public void cancelFirstTimer()
   {
      TimerService timerService = context.getTimerService();
      if (timerService.getTimers().isEmpty())
         throw new EJBException("There are no timers");

      Timer timer = (Timer)timerService.getTimers().iterator().next();
      timer.cancel();
   }

   /**
    * This is not allowed on the remote interface.
    * @ejb.interface-method view-type="both"
    **/
   public Object createTimerReturnHandle(long duration)
   {
      TimerService timerService = context.getTimerService();
      Timer timer = timerService.createTimer(duration, null);
      return timer.getHandle();
   }

   /**
    * This is not allowed on the remote interface.
    * @ejb.interface-method view-type="both"
    **/
   public String passTimerHandle(Object handle)
   {
      return handle.toString();
   }

   /**
    * @ejb.interface-method view-type="both"
    **/
   public void resetCallCount()
   {
      callCount = 0;
      globalCallCount = 0;
   }

   /**
    * @ejb.interface-method view-type="both"
    **/
   public int getCallCount()
   {
      log.info("getCallCount [count=" + callCount + "]");
      return callCount;
   }

   /**
    * @ejb.interface-method view-type="both"
    **/
   public int getGlobalCallCount()
   {
      log.info("getGlobalCallCount [count=" + globalCallCount + "]");
      return globalCallCount;
   }

   /**
    * @ejb.interface-method view-type="both"
    **/
   public List getTimers()
   {
      TimerService timerService = context.getTimerService();

      ArrayList handles = new ArrayList();
      Iterator it = timerService.getTimers().iterator();
      while (it.hasNext())
      {
         Timer timer = (Timer) it.next();
         handles.add(timer.getHandle().toString());
      }
      return handles;
   }

   /**
    * @ejb.interface-method view-type="both"
    **/
   public Principal getEjbTimeoutCaller()
   {
      return ejbTimeoutCaller;
   }

   public void ejbTimeout(Timer timer)
   {
      callCount++;
      globalCallCount++;

      log.info("ejbTimeout [count=" + callCount + "] timer=" + timer);

      ejbTimeoutCaller = context.getCallerPrincipal();
      log.info("ejbTimeout [callerPrincipal=" + ejbTimeoutCaller + "]");

      if (timer.getInfo() != null)
      {
         Properties props = (Properties)timer.getInfo();
         if ("true".equals(props.getProperty("cancel")))
            timer.cancel();
      }
   }

   // -------------------------------------------------------------------------
   // Framework Callbacks
   // -------------------------------------------------------------------------

   public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException
   {
      this.context = ctx;
   }

   /**
    * @ejb.create-method view-type="both"
    **/
   public void ejbCreate() throws CreateException
   {
   }

   public void ejbRemove() throws EJBException, RemoteException
   {
   }

   public void ejbActivate() throws EJBException, RemoteException
   {
   }

   public void ejbPassivate() throws EJBException, RemoteException
   {
   }
}
