/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.txiiop.test;

import javax.naming.InitialContext;
import javax.naming.Context;
import javax.rmi.PortableRemoteObject;
import javax.transaction.UserTransaction;

import org.jboss.test.txiiop.interfaces.StatefulSession;
import org.jboss.test.txiiop.interfaces.StatefulSessionHome;
import org.jboss.test.JBossTestCase;

import junit.framework.Test;

/** Tests of IIOP UserTransaction
 *
 *   @author kimptoc 
 *   @author Scott.Stark@jboss.org 
 *   @author d_jencks converted to JBossTestCase, added logging.
 *   @author reverbel@ime.usp.br 
 *   @version $Revision:1$
 */
public class IIOPUserTransactionStressTestCase
   extends JBossTestCase
{
   // Attributes ----------------------------------------------------
   private java.util.Properties jndiProps;
   
    // Constructors --------------------------------------------------
   public IIOPUserTransactionStressTestCase (String name)
       throws java.io.IOException
   {
      super(name);
      java.net.URL url 
          = ClassLoader.getSystemResource("cosnaming.jndi.properties");
      jndiProps = new java.util.Properties();
      jndiProps.load(url.openStream());
   }

   // Override getInitialContext() ----------------------------------
   protected InitialContext getInitialContext() throws Exception
   {
      return new InitialContext(jndiProps);
   }

   // Public --------------------------------------------------------

   public void testUserTx()
      throws Exception
   {
      getLog().debug("+++ testUsrTx");

      getLog().debug("Obtain home interface");
      // Create a new session object
      Context ctx  = getInitialContext();
      Object ref = ctx.lookup("txiiop/StatefulSessionBean");
      StatefulSessionHome home = 
         (StatefulSessionHome) PortableRemoteObject.narrow(
                                               ref, StatefulSessionHome.class);
      StatefulSession bean = home.create("testUserTx");

      bean.setCounter(100);
      getLog().debug("Try to instantiate a UserTransaction");
      UserTransaction userTx = (UserTransaction)ctx.lookup("UserTransaction");
      userTx.begin();
         bean.incCounter();
         bean.incCounter();
      userTx.commit();
      int counter = bean.getCounter();
      assertTrue("counter == 102", counter == 102);

      bean.setCounter(100);
      userTx.begin();
         bean.incCounter();
         bean.incCounter();
      userTx.rollback();
      counter = bean.getCounter();
      assertTrue("counter == 100", counter == 100);

      bean.remove();
   }

   public void testTxMandatory()
      throws Exception
   {
      getLog().debug("+++ testTxMandatory");

      getLog().debug("Obtain home interface");
      // Create a new session object
      Context ctx  = getInitialContext();
      Object ref = ctx.lookup("txiiop/StatefulSessionBean");
      StatefulSessionHome home = 
         (StatefulSessionHome) PortableRemoteObject.narrow(
                                               ref, StatefulSessionHome.class);
      StatefulSession bean = home.create("testTxMandatory");
      getLog().debug("Call txMandatoryMethod without a UserTransaction");
      try
      {
         bean.txMandatoryMethod("without a UserTransaction");
         getLog().debug("Should not get here!");
         fail("TransactionRequiredException should have been thrown");
      }
      catch (javax.transaction.TransactionRequiredException e)
      {
         getLog().debug("Expected exception: " + e);
      }
      getLog().debug("Begin UserTransaction");
      UserTransaction userTx = (UserTransaction)ctx.lookup("UserTransaction");
      userTx.begin();
         bean.txMandatoryMethod("within a UserTransaction");
      getLog().debug("Commit UserTransaction");
      userTx.commit();
      bean.remove();
   }

   public static Test suite() throws Exception
   {
      return getDeploySetup(IIOPUserTransactionStressTestCase.class, 
                            "txiiop.jar");
   }

}
