/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.test.txiiop.interfaces;

import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBObject;
import javax.ejb.RemoveException;
import org.jboss.test.cts.keys.AccountPK;


/**
 * Interface StatefulSession
 *
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public interface StatefulSession
   extends EJBObject
{
   public void incCounter()
      throws RemoteException;

   public void decCounter()
      throws RemoteException;

   public int getCounter()
      throws RemoteException;

   public void setCounter(int value)
      throws RemoteException;

   public String txMandatoryMethod(String msg)
      throws RemoteException;

}

