/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.tm.test;

import javax.jms.TransactionRolledBackException;
import javax.management.Attribute;
import javax.management.ObjectName;
import javax.transaction.TransactionRolledbackException;

import junit.framework.Test;

import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.test.JBossTestCase;
import org.jboss.test.JBossTestSetup;
import org.jboss.test.tm.interfaces.TxTimeout;
import org.jboss.test.tm.interfaces.TxTimeoutHome;

/**
 * Tests for transaction timeout
 * 
 * @author adrian@jboss.com
 * @version $Revision:1$
 */
public class TxTimeoutUnitTestCase
   extends JBossTestCase
{
   private Integer oldTimeout;
   
   private ObjectName tmService = ObjectNameFactory.create("jboss:service=TransactionManager");
   
   public TxTimeoutUnitTestCase(String name)
   {
      super(name);
   }

   public void testDefaultTimeout() throws Exception
   {
      TxTimeout bean = getBean();
      try
      {
         bean.testDefaultTimeout();
         fail("Expected TransactionRolledbackException");
      }
      catch (TransactionRolledbackException expected)
      {
      }
   }

   public void testOverriddenTimeoutExpires() throws Exception
   {
      TxTimeout bean = getBean();
      try
      {
         bean.testOverriddenTimeoutExpires();
         fail("Expected TransactionRolledbackException");
      }
      catch (TransactionRolledbackException expected)
      {
      }
   }

   public void testOverriddenTimeoutDoesNotExpire() throws Exception
   {
      TxTimeout bean = getBean();
      bean.testOverriddenTimeoutDoesNotExpire();
   }
   
   public static Test suite() throws Exception
   {
      return new JBossTestSetup(getDeploySetup(TxTimeoutUnitTestCase.class, "txtimeouttest.jar"));
   }

   protected void setUp() throws Exception
   {
      setTxTimeout(new Integer(10));
   }
   
   protected void tearDown() throws Exception
   {
      setTxTimeout(oldTimeout);
   }
   
   private void setTxTimeout(Integer timeout) throws Exception
   {
      oldTimeout = (Integer) getServer().getAttribute(tmService, "TransactionTimeout");
      getServer().setAttribute(tmService, new Attribute("TransactionTimeout", timeout));
   }
   
   private TxTimeout getBean() throws Exception
   {
      TxTimeoutHome home = (TxTimeoutHome) getInitialContext().lookup("jbosstest/tm/TxTimeout");
      return home.create();
   }
}
