/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.security.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.Principal;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletException;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class CustomPrincipalServlet extends HttpServlet
{
   protected void doGet(HttpServletRequest request, HttpServletResponse response)
      throws ServletException, IOException
   {
      String type = request.getParameter("type");
      Principal caller = request.getUserPrincipal();
      Class callerClass = caller.getClass();
      if( type.equals(callerClass.getName()) == false )
      {
         throw new ServletException("UserPrincipal type: "+callerClass.getName()
            +" != "+type);
      }
      PrintWriter pw = response.getWriter();
      pw.write("<html>Saw expected UserPrincipal type</html>");
   }
}
