/*
 * JBoss, the OpenSource WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.security.interfaces;

import javax.ejb.*;
import java.rmi.*;

/** A session interface used to test 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */ 
public interface CalledSession extends EJBObject
{
   /** This method should call echo on a StatelessSessionLocal */
   public String invokeEcho(String arg) throws RemoteException;
   /** This method should call invokeEcho on another CalledSession */
   public void callEcho() throws RemoteException;
   /**
    * A method that does nothing but is not assiged a
    * method-permission in the ejb-jar.xml descriptor
    */
   public void noop() throws RemoteException;
}
