/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.messagedriven.support;

import java.util.Properties;

import javax.management.ObjectName;

/**
 * A simple test 
 *
 * @author <a href="mailto:adrian@jboss.com>Adrian Brock</a>
 * @version <tt>$Revision: 1.4</tt>
 */
public abstract class SimpleMessageDrivenUnitTest extends BasicMessageDrivenUnitTest
{
   public SimpleMessageDrivenUnitTest(String name, ObjectName jmxDestination, Properties defaultProps)
   {
      super(name, jmxDestination, defaultProps);
   }
   
   public void testSimpleRequired() throws Exception
   {
      runTest(getOperations(), defaultProps);
   }
   
   public void testSimpleNotSupported() throws Exception
   {
      Properties props = (Properties) defaultProps.clone();
      props.put("transactionAttribute", "NotSupported");
      runTest(getOperations(), props);
   }
   
   public void testSimpleBMT() throws Exception
   {
      Properties props = (Properties) defaultProps.clone();
      props.put("transactionType", "Bean");
      runTest(getOperations(), props);
   }
   
   public void testSimpleDLQ() throws Exception
   {
      Properties props = (Properties) defaultProps.clone();
      props.put("rollback", "DLQ");
      runTest(getDLQOperations(), props);
   }

   public Operation[] getOperations() throws Exception
   {
      return new Operation[]
      {
         new SendMessageOperation(this, "1"),
         new CheckMessageSizeOperation(this, 1),
         new CheckJMSDestinationOperation(this, 0, getDestination().toString()),
         new CheckMessageIDOperation(this, 0, "1"),
      };
   }

   public Operation[] getDLQOperations() throws Exception
   {
      return new Operation[]
      {
         new SendMessageOperation(this, "1"),
         new CheckMessageSizeOperation(this, 7),
         new CheckJMSDestinationOperation(this, 0, getDestination().toString()),
         new CheckJMSDestinationOperation(this, 1, getDestination().toString()),
         new CheckJMSDestinationOperation(this, 2, getDestination().toString()),
         new CheckJMSDestinationOperation(this, 3, getDestination().toString()),
         new CheckJMSDestinationOperation(this, 4, getDestination().toString()),
         new CheckJMSDestinationOperation(this, 5, getDestination().toString()),
         new CheckJMSDestinationOperation(this, 6, getDLQDestination().toString()),
         new CheckMessageIDOperation(this, 0, "1"),
         new CheckMessageIDOperation(this, 1, "1"),
         new CheckMessageIDOperation(this, 2, "1"),
         new CheckMessageIDOperation(this, 3, "1"),
         new CheckMessageIDOperation(this, 4, "1"),
         new CheckMessageIDOperation(this, 5, "1"),
         new CheckMessageIDOperation(this, 6, "1")
      };
   }
}
