/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.messagedriven.support;

import javax.jms.Message;
import javax.jms.MessageProducer;

/**
 * Send a message
 *
 * @author <a href="mailto:adrian@jboss.com>Adrian Brock</a>
 * @version <tt>$Revision: 1.4</tt>
 */
public class SendMessageOperation extends Operation
{
   public static final String MESSAGEID = "jboss_test_MESSAGEID";
   
   protected String id;
   
   public SendMessageOperation(BasicMessageDrivenUnitTest test, String id)
   {
      super(test);
      this.id = id;
   }

   public void run() throws Exception
   {
      MessageProducer producer = test.getMessageProducer();
      Message message = test.getTestMessage();
      message.setStringProperty(MESSAGEID, id);
      producer.send(message);
   }
}
