/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.messagedriven.support;

import javax.jms.Message;

/**
 * Check a message property
 *
 * @author <a href="mailto:adrian@jboss.com>Adrian Brock</a>
 * @version <tt>$Revision: 1.4</tt>
 */
public class CheckMessagePropertyOperation extends Operation
{
   protected int msgNo;
   protected String property;
   protected Object value;
   
   public CheckMessagePropertyOperation(BasicMessageDrivenUnitTest test, int msgNo, String property, Object value)
   {
      super(test);
      this.msgNo = msgNo;
      this.property = property;
      this.value = value;
   }

   public void run() throws Exception
   {
      Message message = (Message) test.getMessages().get(msgNo);
      if (message.propertyExists(property) == false)
         throw new Exception("For msgNo=" + msgNo + " property does not exist property= " + property + " Expected=" + value + " msg=" + message);
      Object actual = message.getObjectProperty(property);
      if (value.equals(actual) == false)
         throw new Exception("For msgNo=" + msgNo + " property= " + property + " Expected=" + value + " actual=" + actual + " msg=" + message);
   }
}
