/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.messagedriven.mbeans;

import java.util.ArrayList;
import java.util.Properties;

import javax.jms.Message;
import javax.management.ObjectName;
import javax.transaction.Transaction;

import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.system.ServiceMBean;

/**
 * Management of the test message driven bean 
 *
 * @author <a href="mailto:adrian@jboss.com>Adrian Brock</a>
 * @version <tt>$Revision: 1.4</tt>
 */
public interface TestMessageDrivenManagementMBean extends ServiceMBean
{
   static ObjectName OBJECT_NAME = ObjectNameFactory.create("jboss.test:service=TestMessageDrivenManagement");
   void initProperties(Properties props);
   void addMessage(Message message);
   ArrayList getMessages();
   Transaction getTransaction();
}
