/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.mdb.bean;

import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.ejb.EJBException;

import javax.jms.MessageListener;
import javax.jms.Message;
import javax.jms.ObjectMessage;

/**
 * ObjectMessageBean.java
 * This test the ability to send an ObjectMessage to a MDB
 *
 * Adapted from the QueueBean class
 * @author Peter Antman DN <peter.antman@dn.se>
 * @author Hiram Chirino (Cojonudo14@hotmail.com)
 *
 */
public class ObjectMessageBean implements MessageDrivenBean, MessageListener
{
   org.apache.log4j.Category log = org.apache.log4j.Category.getInstance(getClass());

   private MessageDrivenContext ctx = null;

   public ObjectMessageBean()
   {

   }

   public void setMessageDrivenContext(MessageDrivenContext ctx) throws EJBException
   {
      this.ctx = ctx;
   }

   public void ejbCreate()
   {
   }

   public void ejbRemove()
   {
      ctx = null;
   }

   // NOT From javax.jms.MessageListener
   public void onMessage()
   {
   }

   // NOT From javax.jms.MessageListener
   public void onMessage2()
   {
   }

   // NOT From javax.jms.MessageListener
   public void onMessage(ObjectMessage om)
   {
   }

   public void onMessage(Message message)
   {
      try
      {
         ObjectMessage om = (ObjectMessage) message;
         log.debug("DEBUG: ObjectMessageBean got object: " + om.getObject().toString());
      }
      catch (Throwable e)
      {
         log.error("failed", e);
      }
   }
}

