/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.test.jmx.xmbean;

import javax.management.AttributeChangeNotification;
import javax.management.Notification;
import javax.management.NotificationListener;

import org.jboss.system.ServiceMBeanSupport;

/**
 * An XMBean wrapped Service that listens for notification from
 * itself, and expects to receive an AttributeChangeNotification
 * for Attr1. Baseclass ServiceMBeanSupport will also produce AVC
 * for the inherited State attribute, but we are not interested
 * for this.
 * 
 * @author  gunter.zeilinger@tiani.com
 * @author  <a href="mailto:dimitris@jboss.org">Dimitris Andreadis</a>
 * 
 * @version $Revision:1$
 */
public class SelfListenerService
   extends ServiceMBeanSupport
   implements NotificationListener
{
   private boolean attr1 = false;
   private boolean gotAttr1AVC = false;
   
   public boolean getAttr1()
   {
      return attr1;
   }
   
   public void setAttr1(boolean attr1)
   {
      this.attr1 = attr1;
   }
   
   public boolean getGotAttr1AVC()
   {
      return gotAttr1AVC;
   }
   
   protected void startService()
      throws Exception
   {
      server.addNotificationListener(super.serviceName, this, null, null);
   }
   
   protected void stopService()
      throws Exception
   {
      server.removeNotificationListener(super.serviceName, this);
   }
   
   public void handleNotification(Notification notif, Object handback)
   {
      log.info("handleNotification: " + notif);
      
      if (notif instanceof AttributeChangeNotification)
      {
         AttributeChangeNotification avc = (AttributeChangeNotification)notif;
         
         if (avc.getAttributeName().equals("Attr1"))
         {
            Boolean newValue = (Boolean)avc.getNewValue();
            
            if (Boolean.TRUE.equals(newValue))
               this.gotAttr1AVC = true;
         }
      }
   }
}
